/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.util.FileUtil;

public class SettingHooks {
    public static void saveSettings() {
        try {
            SettingHooks.saveXPSettings();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed saving settings", (Throwable)e);
        }
    }

    public static synchronized void saveXPSettings() throws IOException {
        FileUtil.safeSave(XaeroPlus.configFile, w -> {
            try (PrintWriter writer = new PrintWriter((Writer)w);){
                List<XaeroPlusSetting> allSettings = Settings.REGISTRY.getAllSettings().stream().sorted(Comparator.comparing(XaeroPlusSetting::getSettingName)).toList();
                for (int i = 0; i < allSettings.size(); ++i) {
                    XaeroPlusSetting setting = allSettings.get(i);
                    writer.println(setting.getSettingName() + ":" + setting.getSerializedValue());
                }
            }
        });
    }

    public static synchronized void loadXPSettings() {
        try {
            if (!XaeroPlus.configFile.exists()) {
                return;
            }
            SettingHooks.loadXPSettingsFromFile(XaeroPlus.configFile);
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Error loading XaeroPlus settings", e);
        }
    }

    public static synchronized void loadXPSettingsFromFile(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = reader.readLine()) != null) {
                String settingName;
                int colonIndex = s.indexOf(58);
                if (colonIndex == -1 || (settingName = s.substring(0, colonIndex)).isBlank()) continue;
                String settingValue = s.substring(colonIndex + 1);
                XaeroPlusSetting setting = Settings.REGISTRY.getSettingByName(settingName);
                if (setting == null) {
                    XaeroPlus.LOGGER.warn("Setting not found: {}", (Object)settingName);
                    continue;
                }
                setting.deserializeValue(settingValue);
            }
        }
    }
}

